<?php

namespace NumberToWords\NumberTransformer;

class MacedonianNumberTransformerTest extends NumberTransformerTest
{
    protected function setUp(): void
    {
        $this->numberTransformer = new MacedonianNumberTransformer();
    }

    public function providerItConvertsNumbersToWords(): array
    {
        return [
            [-100, 'минус сто'],
            [-50, 'минус педесет'],
            [-30, 'минус триесет'],
            [-2, 'минус два'],
            [0, 'нула'],
            [1, 'еден'],
            [2, 'два'],
            [3, 'три'],
            [4, 'четири'],
            [5, 'пет'],
            [6, 'шест'],
            [7, 'седум'],
            [8, 'осум'],
            [9, 'девет'],
            [10, 'десет'],
            [11, 'единаесет'],
            [12, 'дванаесет'],
            [13, 'тринаесет'],
            [14, 'четиринаесет'],
            [15, 'петнаесет'],
            [16, 'шеснаесет'],
            [17, 'седумнаесет'],
            [18, 'осумнаесет'],
            [19, 'деветнаесет'],
            [20, 'дваесет'],
            [21, 'дваесет и еден'],
            [26, 'дваесет и шест'],
            [30, 'триесет'],
            [31, 'триесет и еден'],
            [40, 'четириесет'],
            [43, 'четириесет и три'],
            [50, 'педесет'],
            [55, 'педесет и пет'],
            [60, 'шеесет'],
            [67, 'шеесет и седум'],
            [70, 'седумдесет'],
            [79, 'седумдесет и девет'],
            [80, 'осумдесет'],
            [90, 'деведесет'],
            [99, 'деведесет и девет'],
            [100, 'сто'],
            [101, 'сто и еден'],
            [199, 'сто деведесет и девет'],
            [203, 'двесте и три'],
            [287, 'двесте осумдесет и седум'],
            [300, 'триста'],
            [356, 'триста педесет и шест'],
            [410, 'четиристотини и десет'],
            [434, 'четиристотини триесет и четири'],
            [578, 'петстотини седумдесет и осум'],
            [689, 'шестотини осумдесет и девет'],
            [729, 'седумстотини дваесет и девет'],
            [894, 'осумстотини деведесет и четири'],
            [999, 'деветстотини деведесет и девет'],
            [1000, 'илјада'],
            [1001, 'илјада и еден'],
            [1097, 'илјада и деведесет и седум'],
            [1104, 'илјада сто и четири'],
            [1243, 'илјада двесте четириесет и три'],
            [2385, 'две илјади триста осумдесет и пет'],
            [3766, 'три илјади седумстотини шеесет и шест'],
            [4196, 'четири илјади сто деведесет и шест'],
            [5846, 'пет илјади осумстотини четириесет и шест'],
            [6459, 'шест илјади четиристотини педесет и девет'],
            [7232, 'седум илјади двесте триесет и два'],
            [8569, 'осум илјади петстотини шеесет и девет'],
            [21000, 'дваесет и една илјада'],
            [30333, 'триесет илјади триста триесет и три'],
            [50201, 'педесет илјади двесте и еден'],
            [100001, 'сто илјади и еден'],
            [101001, 'сто и една илјада и еден'],
            [220523, 'двесте и дваесет илјади петстотини дваесет и три'],
            [565300, 'петстотини шеесет и пет илјади и триста'],
            [999999, 'деветстотини деведесет и девет илјади деветстотини деведесет и девет'],
            [1000000, 'еден милион'],
            [99999999, 'деведесет и девет милиони деветстотини деведесет и девет илјади деветстотини деведесет и девет'],
            [321531512, 'триста дваесет и еден милион петстотини триесет и една илјада петстотини и дванаесет'],
            [1000000000, 'една милјарда'],
            [101000000000, 'сто и една милјарда'],
            [61234123124125, 'шеесет и еден трилион двесте триесет и четири милјарди сто дваесет и три милиони сто дваесет и четири илјади сто дваесет и пет'],
            [121125125125124, 'сто дваесет и еден трилион сто дваесет и пет милјарди сто дваесет и пет милиони сто дваесет и пет илјади сто дваесет и четири'],
            [235235321531512, 'двесте триесет и пет трилиони двесте триесет и пет милјарди триста дваесет и еден милион петстотини триесет и една илјада петстотини и дванаесет'],
        ];
    }
}
